package gov.va.med.mhv.admin.service.mhvusers;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;


public interface FacilityInfoService {

	/**
	 * Save the FacilityInfo
	 *
	 * @param entity FacilityInfo to save
	 * @return FacilityInfo The saved FacilityInfo
	 */
	public FacilityInfoDTO saveFacilityInfo(FacilityInfoDTO facilityInfo);

	/**
	 * Execute the getAllFacilityInfos query
	 *
	 * @return List of FacilityInfos
	 */	 
	public List<FacilityInfoDTO> getAllFacilityInfos();

	/**
	 * Execute the queryByStationNumber query
	 *
	 * @param stationNumber The stationNumber
	 * @return List of FacilityInfos
	 */	 
	public List<FacilityInfoDTO> queryByStationNumber(String stationNumber);
	
	public FacilityInfoDTO getFacilityInfoById(Long facilityInfoId)  throws MHVException;
}
